﻿#########################################
## Mimic with eye-contact              ##
## Author: Frank Verberne              ##
## Eindhoven University of Technology  ##
## Contact: frankverberne at gmail.com ##
#########################################
import viz
import viztask
import vizact
import cPickle
import random

viz.go()

#CONSTANTS
BLINKING = True

#<AVATAR>#
avatar = viz.add('vcc_male2.cfg', pos = [0,.15,.5], euler = [180,0,0])
eyeBlinkBoneList = ['Bip01 LEyeBlinkBottom', 'Bip01 LEyeBlinkTop', 'Bip01 REyeBlinkBottom', 'Bip01 REyeBlinkTop']
boneObjList = []
for bones in eyeBlinkBoneList:
    boneObjList.append(avatar.getBone(bones))

for bones in boneObjList:
    bones.lock()

avatar.idlepose(-1)
#</AVATAR>#

#<LIGHTS>#
viz.MainView.getHeadLight().disable()
light1 = viz.addLight(euler = [0,90,0])
light2 = viz.addLight(euler = [55,0,0])
light3 = viz.addLight(euler = [-55,0,0])
light4 = viz.addLight(euler = [0,-90,0])
#</LIGHTS>#

#<BLINKING>#
BLINK_DATA = open('.\\Blink_animation.log', 'r')
boneMatList = cPickle.load(BLINK_DATA)
new_boneMatList = []

for i, mat in enumerate(boneMatList):
    if i % 8 in (0,1,2,3):
        new_boneMatList.append(mat)

def blink():
    for i ,mat in enumerate(new_boneMatList):
        boneObjList[i % len(eyeBlinkBoneList)].setMatrix(mat, viz.ABS_PARENT)
        yield None
#        yield viztask.waitDraw()

def blinking():
    while BLINKING: 
        random_float = random.uniform(1,5)
        print 'Blink after', random_float, 'seconds'
        yield viztask.waitTime(random_float)
        viztask.schedule(blink)

if BLINKING:
    viztask.schedule(blinking)
#</BLINKING>#

#<EYE_MOVEMENT>#
global yaw_correction, pitch_correction
yaw_correction = 0 
pitch_correction = 0
neck = avatar.getBone('Bip01 Head')
leftEye = avatar.getBone('Bip01 LEye')
rightEye = avatar.getBone('Bip01 REye')
leftEye.lock()
rightEye.lock()
neck.lock()

def fixEyes():
    global yaw_correction, pitch_correction, roll_correction
    eye_euler = neck.getEuler(viz.AVATAR_WORLD)
    eye_euler[0] = eye_euler[0] + yaw_correction
    eye_euler[1] = eye_euler[1] + pitch_correction
    moveLeftEye = vizact.boneSpinTo(leftEye, mode= viz.AVATAR_WORLD, euler=eye_euler, speed = 40)
    moveRightEye = vizact.boneSpinTo(rightEye, mode= viz.AVATAR_WORLD, euler=eye_euler, speed = 40)
    avatar.runAction(moveLeftEye, 0) 
    avatar.runAction(moveRightEye, 1)

vizact.ontimer(1/60, fixEyes)

def moveEyes():
    global yaw_correction, pitch_correction
    while True:
        yaw_correction = random.uniform(-15,15)
        pitch_correction = random.uniform(-10,10)
        random_wait = random.uniform(2,6)
        print 'Move eyes in', random_wait, 'seconds'
        yield viztask.waitTime(random_wait)

viztask.schedule(moveEyes)
#</EYE_MOVEMENT>#